/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.i18n;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.util.i18n.PropertiesCpResourceBundle;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class CpControl
extends ResourceBundle.Control {
    private static final String FORMAT = "cp.properties";

    @Override
    public List<String> getFormats(String baseName) {
        return Collections.singletonList(FORMAT);
    }

    @Override
    public boolean needsReload(String baseName, Locale locale, String format, ClassLoader loader, ResourceBundle bundle, long loadTime) {
        boolean res;
        URL url = this.getResource(baseName, locale, loader);
        try {
            long modTime = url.openConnection().getLastModified();
            res = modTime > loadTime;
        }
        catch (IOException e) {
            res = false;
        }
        return res;
    }

    @Override
    public ResourceBundle newBundle(String baseName, Locale locale, String format, ClassLoader loader, boolean reload) throws IllegalAccessException, InstantiationException, IOException {
        Preconditions.checkState(FORMAT.equals(format));
        PropertiesCpResourceBundle bundle = null;
        URL url = this.getResource(baseName, locale, loader);
        if (url != null) {
            bundle = new PropertiesCpResourceBundle(url);
        }
        return bundle;
    }

    private URL getResource(String baseName, Locale locale, ClassLoader loader) {
        return loader.getResource(this.toResourceName(this.toBundleName(baseName, locale), "properties"));
    }

    @Override
    public long getTimeToLive(String baseName, Locale locale) {
        return 10000L;
    }
}

